<?php
	session_start();
	require_once "PagSeguroLibrary.php";
	/**
	 * Class with a main method to illustrate the usage of the domain class PaymentRequest
	 */
	class createPaymentRequest {
		
		public static function main () {
			//Include de conexao e variaveis
			require("../engine/conexao.php");
			require("../funcoes/verificaArquivo.php");
			require("../funcoes/verificaCategoria.php");
			
			// Instantiate a new payment request
			$paymentRequest = new PaymentRequest();
			
			// Sets the currency
			$paymentRequest->setCurrency("BRL");
			
			$cad = verificaTabela("cadastro WHERE idCadastro = ".$_GET['idc']);
			$prod = verificaTabela("planos WHERE idPlano = ".$_GET['idp']);
			
			$valor = "";
			if(strpbrk($prod['fltValor'], '.') == false){
				$valor = $prod['fltValor'].".00";
			}else{
				$v = explode(".", $prod['fltValor']);
				if(strlen($v[1])>1){
					$valor = $v[0].".".$v[1];
				}else{
					$valor = $v[0].".".$v[1]."0";
				}
			}
			$idv = rand(111111111, 999999999);
			$sqlv = "INSERT INTO venda VALUES($idv, '".date('Y-m-d').", '".$_GET['idc']."', '".$_GET['idp']."', '0')";
			
			//echo "$idv-".$prod['strNome']."-1-".$prod['fltValor']."-0";
			$paymentRequest->addItem($idv, $prod['strNome'], 1, $valor, 0);
			
			$paymentRequest->setReference($idv.'*'.$_GET['type']);
			
			

			
			
			try {
				
				/*
				* #### Crendencials ##### 
				* Substitute the parameters below with your credentials (e-mail and token)
				* You can also get your credentails from a config file. See an example:
				* $credentials = PagSeguroConfig::getAccountCredentials();
				*/
				$credentials = new AccountCredentials("marcelo@opdigital.com.br", "B4C99136D4D34B4AA6B1B8BBD10F7C3F");
				
				// Register this payment request in PagSeguro, to obtain the payment URL for redirect your customer.
				$url = $paymentRequest->register($credentials);
				
				self::printPaymentUrl($url);
				
			} catch (PagSeguroServiceException $e) {
				die($e->getMessage());
			}
			
		}
		
		public static function printPaymentUrl($url) {
			if($url){
		?>
				<script type="text/javascript">
				<!--
					document.location = "<?=$url?>";
				//-->
				</script>
		<?
			}
		}
		
	}

	createPaymentRequest::main();

?>
