<?php
/**
* Represents the party on the transaction that is sending the money
*/	
class Sender {

	/** Sender name */
	private $name;
	
	/** Sender email */
	private $email;
	
	/** Sender phone */
	private $phone;
	
	/**
	 * Initializes a new instance of the Sender class
	 * 
	 * @param array $data
	 */
	public function __construct(Array $data = null) {
		if ($data) {
			if (isset($data['name'])) {
				$this->name = $data['name'];
			}		
			if (isset($data['email'])) {
				$this->email = $data['email'];
			}		
			if (isset($data['phone']) && $data['phone'] instanceof Phone) {
				$this->phone = $data['phone'];
			} else if (isset($data['areaCode']) && isset($data['number'])) {
				$phone = new Phone($data['areaCode'], $data['number']);
				$this->phone = $phone;
			}
		}
	}
	
	/**
	 * Sets the sender name
	 * @param String $name
	 */
	public function setName($name) {
		$this->name = $name;
	}
	
	/**
	 * @return the sender name
	 */
	public function getName() {
		return $this->name;
	}
	
	/**
	 * Sets the Sender e-mail
	 * @param email
	 */
	public function setEmail($email) {
		$this->email = $email;
	}
	
	/**
	 * @return the sender e-mail
	 */
	public function getEmail() {
		return $this->email;
	}

	/**
	 * Sets the sender phone
	 * @param String $areaCode
	 * @param String $number
	 */
	public function setPhone($areaCode, $number= null) {
		$param = $areaCode;
		if ($param instanceof Phone) {
			$this->phone = $param;
		} elseif($number) {
			$phone = new Phone();
			$phone->setAreaCode($areaCode);
			$phone->setNumber($number);
			$this->phone = $phone;
		}
	}
	
	/**
	 * @return the sender phone
	 * @see Phone
	 */
	public function getPhone() {
		return $this->phone;
	}
	
}

?>