<?
	function imagem($nome, $alt, $opcao = null){
		$src = "images/".$nome;
		if(isset($opcao['size'])){
			$size = dimensoes($src, $opcao['size']);
			$size = explode("/", $size);
			list($opcao['width'], $opcao['height']) = explode('x', $size[0], 2);
			if($size[1] != "") $opcao['style'] .= $size[1];
			unset($opcao['size']);
		}
		
		$imprima = '<img src="'.$src.'" alt="CVU NetCar" title="CVU NetCar" '.printOptions($opcao).' autocomplete="off" />';
		
		return $imprima;
	}
	
	function printOptions($options = array()){
		$html = '';
		if(!is_null($options)){
			foreach ($options as $key => $value){
				if($key != "src" && $key != "alt")
					$html .= ' '.$key.'="'.escape_once($value).'"';
			}
		}
		
		return $html;
	}
	
	function dimensoes($src, $dimensions = null){
		$tam = verificaTamanhoImagem($src);
		$width = ""; $height = ""; $style = "";
		
		if($dimensions != ""){
			$dim = explode("x", $dimensions);
			$width = $dim[0]; $height = $dim[1];
		}
		
		if($width == ""){
			if($height == ""){
				$height = $tam[1];
				$width = $tam[0];
			} else $width = round(($tam[0]*$height)/$tam[1]);
		} else{
			if($height == "") $height = round(($tam[1]*$width)/$tam[0]);
			else{
				if($tam[0] < $tam[1]){
					$w = $width;
					$width = round(($tam[0]*$height)/$tam[1]);
					$style = "margin-left: ".round(($w - $width)/2)."px;";
				} else{
					$h = $height;
					$height = round(($tam[1]*$width)/$tam[0]);
					$style = "margin-top: ".round(($h - $height)/2)."px;";
				}
			}
		}
		
		return $t = $width."x".$height."/".$style;
	}
	
	function verificaTamanhoImagem($imagem){
		$tam_img = getimagesize($imagem);
		
		return $tam_img;
	}
?>