function delCategoria(id) {
    $.post('control/controleCategorias.php', {opcao: 'excluir', idCategoria: id},
    function (r) {
        console.log(r);
        $("#listaCategorias").load('listaCategoriasAjax.php');
        $('#confirm-delete').modal('hide');
    })
}

function listaCategoria(id) {
    $.post('control/controleCategorias.php', {opcao: 'listaCategoria', idCategoria: id, formato: 'json'},
    function (r) {
        var resposta = $.parseJSON(r);

        var idCategoria = resposta[0].idCategoria;
        var nome = resposta[0].nome;

        $("#categoria").val(nome);
        $("#idCategoria").val(idCategoria);
        $("#opcao").val('alterar');
        $(".btn-success").val('Alterar');


        $("#myModal").modal('show');
    })
}

$(document).ready(function () {
    $("#btnCadCategoria").click(function () {
        var opcao = $("#opcao").val();
        var idCategoria = ($("#idCategoria").length) ? $("#idCategoria").val() : '';
        var nome = $("#categoria").val();

        if (nome == '') {
            validateBootstrap('categoria', 'Você deve informar o nome da categoria!', 1);
        } else {
            validateBootstrap('categoria', '', 0);

            $.post('control/controleCategorias.php', {opcao: opcao, idCategoria: idCategoria, nome: nome},
            function (r) {

                $("#opcao").val('cadastrar');
                $(".btn-success").val('Cadastrar');

                $("#categoria").val('');
                $("#idCategoria").val('');
                $("#form-group-categoria").removeClass('has-success has-feedback');
                $("#icon-categoria").removeClass('glyphicon-ok');

                $("#myModal").modal('hide');

                $("#listaCategorias").load('listaCategoriasAjax.php');
            })
        }
    });

    $('#confirm-delete').on('show.bs.modal', function (e) {
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));

        $('.categoria-nome').html('Nome da Categoria: <strong>' + $(e.relatedTarget).data('extra') + '</strong>');
    });
})/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


