function delNewsletter(id) {
    $.post('control/controleNewsletter.php', {opcao: 'excluir', cadNews: id},
    function (r) {
        console.log(r);
        $("#listaNewsletter").load('listaNewsletterAjax.php');
        $('#confirm-delete').modal('hide');
    })
}

function listaNewsletter(id) {
    $.post('control/controleNewsletter.php', {opcao: 'listaNewsletter', cadNews: id, formato: 'json'},
    function (r) {
        var resposta = $.parseJSON(r);

        var cadNews = resposta[0].cadNews;
        var email = resposta[0].email;

        $("#email").val(email);
        $("#cadNews").val(cadNews);
        $("#opcao").val('alterar');
        $(".btn-success").val('Alterar');

        $("#myModal").modal('show');
    })
}

$(document).ready(function () {
    $("#btnCadNewsletter").click(function () {
        var opcao = $("#opcao").val();
        var cadNews = ($("#cadNews").length) ? $("#cadNews").val() : '';
        var email = $("#email").val();

        if (email == '') {
            validateBootstrap('email', 'Você deve informar o email!', 1);
        } else {
            validateBootstrap('email', '', 0);

            $.post('control/controleNewsletter.php', {opcao: opcao, cadNews: cadNews, email: email},
            function (r) {

                $("#opcao").val('cadastrar');
                $(".btn-success").val('Cadastrar');

                $("#categoria").val('');
                $("#cadNews").val('');
                $("#form-group-newsletter").removeClass('has-success has-feedback');
                $("#icon-newsletter").removeClass('glyphicon-ok');

                $("#myModal").modal('hide');

                $("#listaNewsletter").load('listaNewsletterAjax.php');
            })
        }
    });

    $('#confirm-delete').on('show.bs.modal', function (e) {
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));

        $('.newsletter-nome').html('E-mail: <strong>' + $(e.relatedTarget).data('extra') + '</strong>');
    });
})/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */