function delPost(id) {
    $.post('control/controlePost.php', {opcao: 'excluir', idPost: id},
    function (r) {
        console.log(r);
        $("#listaPost").load('listaPostAjax.php');
        $('#confirm-delete').modal('hide');
    })
}

function listaPost(id) {
    $.post('control/controlePosts.php', {opcao: 'listaPost', idPost: id, formato: 'json'},
    function (r) {
        var resposta = $.parseJSON(r);

        var idPost = resposta[0].idPost;
        var nome = resposta[0].nome;

        $("#categoria").val(nome);
        $("#idPost").val(idPost);
        $("#opcao").val('alterar');
        $(".btn-success").val('Alterar');


        $("#myModal").modal('show');
    })
}

$(document).ready(function () {
    $("#btnCadPost").click(function () {
        var opcao = $("#opcao").val();
        var idPost = ($("#idPost").length) ? $("#idPost").val() : '';
        var nome = $("#categoria").val();

        if (nome == '') {
            validateBootstrap('categoria', 'Você deve informar o nome da categoria!', 1);
        } else {
            validateBootstrap('categoria', '', 0);

            $.post('control/controlePost.php', {opcao: opcao, idPost: idPost, nome: nome},
            function (r) {

                $("#opcao").val('cadastrar');
                $(".btn-success").val('Cadastrar');

                $("#categoria").val('');
                $("#idPost").val('');
                $("#form-group-categoria").removeClass('has-success has-feedback');
                $("#icon-categoria").removeClass('glyphicon-ok');

                $("#myModal").modal('hide');

                $("#listaPost").load('listaPostAjax.php');
            })
        }
    });

    $('#confirm-delete').on('show.bs.modal', function (e) {
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));

        $('.post-titulo').html('Título do Post: <strong>' + $(e.relatedTarget).data('extra') + '</strong>');
    });
})/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */


